<?php

use Codexpert\CoDesigner\Helper;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Text_Stroke;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$widget = $args['this'];

/**
 * default woocommerce checkout style controls
 */
$widget->start_controls_section(
    'cd_checkout_block_style',
    [
        'label'      => __( 'Checkout Section', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'default',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name' 		=> 'cd_checkout_block_background',
        'types' 	=> [ 'classic', 'gradient' ],
        'selector' 	=> '{{WRAPPER}} .woocommerce',
    ]
);

$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name' 		=> 'cd_checkout_block_border',
        'selector' 	=> '{{WRAPPER}} .woocommerce',
    ]
);

$widget->add_control(
    'cd_checkout_block_border_radius_style',
    [
        'label' 		=> esc_html__( 'Border Radius', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .woocommerce' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' 		=> 'cd_checkout_block_box_shadow',
        'selector' 	=> '{{WRAPPER}} .woocommerce',
    ]
);

$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_coupon_heading_style',
    [
        'label'      => __( 'Coupon Heading', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'default',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_coupon_heading_typography',
        'selector'  => '{{WRAPPER}} .woocommerce .woocommerce-info',
    ]
);

$widget->add_control(
    'cd_checkout_coupon_heading_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce .woocommerce-info' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_coupon_heading_background',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce .woocommerce-info' => 'background: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_show_coupon_text_color',
    [
        'label'     => esc_html__( 'Show Coupon Text Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce .woocommerce-info .showcoupon' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name' => 'cd_checkout_coupon_heading_border',
        'selector' => '{{WRAPPER}} .woocommerce .woocommerce-info',
    ]
);

$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_coupon_form_style',
    [
        'label'      => __( 'Coupon Form', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'default',
        ],
    ]
);

$widget->start_controls_tabs(
    'cd_checkout_coupon_form_style_tabs'
);

$widget->start_controls_tab(
    'cd_checkout_coupon_form_message_tab',
    [
        'label' => esc_html__( 'Message', 'codesigner-pro' ),
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_coupon_form_message_typography',
        'selector'  => '{{WRAPPER}} .woocommerce .checkout_coupon.woocommerce-form-coupon p',
    ]
);

$widget->add_control(
    'cd_checkout_coupon_form_message_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce .checkout_coupon.woocommerce-form-coupon p' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->end_controls_tab();

$widget->start_controls_tab(
    'cd_checkout_coupon_form_input_tab',
    [
        'label' => esc_html__( 'Input', 'codesigner-pro' ),
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_coupon_form_input_typography',
        'selector'  => '{{WRAPPER}} .woocommerce .checkout_coupon.woocommerce-form-coupon .form-row input.input-text',
    ]
);

$widget->add_control(
    'cd_checkout_coupon_form_input_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce .checkout_coupon.woocommerce-form-coupon .form-row input.input-text' => 'color: {{VALUE}}',
            '{{WRAPPER}} .woocommerce .checkout_coupon.woocommerce-form-coupon .form-row input.input-text:focus' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_coupon_form_input_placeholder_color',
    [
        'label'     => esc_html__( 'Placeholder Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce .checkout_coupon.woocommerce-form-coupon .form-row input.input-text::placeholder' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_coupon_form_input_background',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce .checkout_coupon.woocommerce-form-coupon .form-row input.input-text' => 'background: {{VALUE}}',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name' 		=> 'cd_checkout_coupon_form_input_border',
        'selector' 	=> '{{WRAPPER}} .woocommerce .checkout_coupon.woocommerce-form-coupon .form-row input.input-text , 
                        {{WRAPPER}} .woocommerce .checkout_coupon.woocommerce-form-coupon .form-row input.input-text:focus',
    ]
);

$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' 		=> 'cd_checkout_coupon_form_input_box_shadow',
        'selector' 	=> '{{WRAPPER}} .woocommerce .checkout_coupon.woocommerce-form-coupon .form-row input.input-text',
    ]
);

$widget->add_control(
    'cd_checkout_coupon_form_input_padding',
    [
        'label' 		=> esc_html__( 'Padding', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .woocommerce .checkout_coupon.woocommerce-form-coupon .form-row input.input-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->end_controls_tab();

$widget->end_controls_tabs();

$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_coupon_from_apply_style',
    [
        'label'      => __( 'Coupon Form Submit', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'default',
        ],
    ]
);

$widget->start_controls_tabs(
    'cd_checkout_coupon_form_apply_style_tabs'
);

$widget->start_controls_tab(
    'cd_checkout_coupon_form_normal_tab',
    [
        'label' => esc_html__( 'Normal', 'codesigner-pro' ),
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_coupon_form_normal_apply_typography',
        'selector'  => '{{WRAPPER}} .woocommerce .checkout_coupon.woocommerce-form-coupon .form-row.form-row-last button.button',
    ]
);

$widget->add_control(
    'cd_checkout_coupon_form_normal_apply_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce .checkout_coupon.woocommerce-form-coupon .form-row.form-row-last button.button' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_coupon_form_normal_apply_background',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce .checkout_coupon.woocommerce-form-coupon .form-row.form-row-last button.button' => 'background: {{VALUE}}',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name' 		=> 'cd_checkout_coupon_form_normal_apply_border',
        'selector' 	=> '{{WRAPPER}} .woocommerce .checkout_coupon.woocommerce-form-coupon .form-row.form-row-last button.button',
    ]
);

$widget->add_control(
    'cd_checkout_coupon_form_normal_apply_border_radius',
    [
        'label' 		=> esc_html__( 'Border Radius', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .woocommerce .checkout_coupon.woocommerce-form-coupon .form-row.form-row-last button.button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' 		=> 'cd_checkout_coupon_form_normal_apply_box_shadow',
        'selector' 	=> '{{WRAPPER}} .woocommerce .checkout_coupon.woocommerce-form-coupon .form-row.form-row-last button.button',
    ]
);

$widget->add_control(
    'cd_checkout_coupon_form_normal_apply_padding',
    [
        'label' 		=> esc_html__( 'Padding', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .woocommerce .checkout_coupon.woocommerce-form-coupon .form-row.form-row-last button.button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->end_controls_tab();

$widget->start_controls_tab(
    'cd_checkout_coupon_form_hover_tab',
    [
        'label' => esc_html__( 'Hover', 'codesigner-pro' ),
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_coupon_form_hover_apply_typography',
        'selector'  => '{{WRAPPER}} .woocommerce .checkout_coupon.woocommerce-form-coupon .form-row.form-row-last button.button:hover',
    ]
);

$widget->add_control(
    'cd_checkout_coupon_form_hover_apply_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce .checkout_coupon.woocommerce-form-coupon .form-row.form-row-last button.button:hover' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_coupon_form_hover_apply_background',
    [
        'label'     => esc_html__( 'Background', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce .checkout_coupon.woocommerce-form-coupon .form-row.form-row-last button.button:hover' => 'background: {{VALUE}}',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name' 		=> 'cd_checkout_coupon_form_hover_apply_border',
        'selector' 	=> '{{WRAPPER}} .woocommerce .checkout_coupon.woocommerce-form-coupon .form-row.form-row-last button.button:hover',
    ]
);

$widget->add_control(
    'cd_checkout_coupon_form_hover_apply_border_radius',
    [
        'label' 		=> esc_html__( 'Border Radius', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .woocommerce .checkout_coupon.woocommerce-form-coupon .form-row.form-row-last button.button:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' 		=> 'cd_checkout_coupon_form_hover_apply_box_shadow',
        'selector' 	=> '{{WRAPPER}} .woocommerce .checkout_coupon.woocommerce-form-coupon .form-row.form-row-last button.button:hover',
    ]
);

$widget->add_control(
    'cd_checkout_coupon_form_hover_apply_padding',
    [
        'label' 		=> esc_html__( 'Padding', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .woocommerce .checkout_coupon.woocommerce-form-coupon .form-row.form-row-last button.button:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->end_controls_tab();

$widget->end_controls_tabs();

$widget->end_controls_section();

$widget->start_controls_section(
    'cd_address_section_style',
    [
        'label'      => __( 'Address Section', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'default',
        ],
    ]
);

$widget->add_control(
    'cd_address_section_background_color',
    [
        'label' 	=> esc_html__( 'Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce .woocommerce-checkout #customer_details' => 'background: {{VALUE}} !important',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name' 		=> 'cd_address_section_border',
        'selector' 	=> '{{WRAPPER}} .woocommerce .woocommerce-checkout #customer_details',
    ]
);

$widget->add_control(
    'cd_address_section_border_radius',
    [
        'label' 		=> esc_html__( 'Border-radius', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .woocommerce .woocommerce-checkout #customer_details' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} 0 0;',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' 			=> 'cd_address_section_box_shadow',
        'selector' 		=> '{{WRAPPER}} .woocommerce .woocommerce-checkout #customer_details',
    ]
);

$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_section_title_style',
    [
        'label'      => __( 'Address Section\'s Title', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'default',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_section_title_typography',
        'selector'  => '{{WRAPPER}} #customer_details h3:not(.elementor-widget-woocommerce-checkout-page h3)',
    ]
);

$widget->add_control(
    'cd_checkout_section_title_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #customer_details h3:not(.elementor-widget-woocommerce-checkout-page h3)' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Text_Stroke::get_type(),
    [
        'name'      => 'cd_checkout_section_title_stroke',
        'selector'  => '{{WRAPPER}} #customer_details h3:not(.elementor-widget-woocommerce-checkout-page h3)',
    ]
);

$widget->add_group_control(
    Group_Control_Text_Shadow::get_type(),
    [
        'name' 		=> 'cd_checkout_section_title_shadow',
        'selector' 	=> '{{WRAPPER}} #customer_details h3:not(.elementor-widget-woocommerce-checkout-page h3)',
    ]
);

$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_form_label_style',
    [
        'label'      => __( 'Address Form', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'default',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name' 		=> 'cd_checkout_address_form_background',
        'types' 	=> [ 'classic', 'gradient' ],
        'selector' 	=> '{{WRAPPER}} .woocommerce .woocommerce-checkout #customer_details .form-row',
    ]
);

$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' 		=> 'cd_checkout_address_form_input_box_shadow',
        'selector' 	=> '{{WRAPPER}} .woocommerce .woocommerce-checkout #customer_details .form-row',
    ]
);

$widget->add_control(
    'cd_checkout_address_form_margin',
    [
        'label' 		=> esc_html__( 'Margin', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .woocommerce .woocommerce-checkout #customer_details .form-row' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_address_form_padding',
    [
        'label' 		=> esc_html__( 'Padding', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .woocommerce .woocommerce-checkout #customer_details .form-row' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_address_form_border_radius',
    [
        'label' 		=> esc_html__( 'Border Radius', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .woocommerce .woocommerce-checkout #customer_details .form-row' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->start_controls_tabs(
    'cd_checkout_address_form_style_tabs'
);

$widget->start_controls_tab(
    'cd_checkout_address_form_label_tab',
    [
        'label' => esc_html__( 'Label', 'codesigner-pro' ),
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'cd_checkout_address_form_label_typography',
        'selector'  => '{{WRAPPER}} .woocommerce-checkout #customer_details .form-row label',
    ]
);

$widget->add_control(
    'cd_checkout_address_form_label_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce-checkout #customer_details .form-row label' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Text_Stroke::get_type(),
    [
        'name'      => 'cd_checkout_address_form_label_stroke',
        'selector'  => '{{WRAPPER}} .woocommerce-checkout #customer_details .form-row label',
    ]
);

$widget->add_group_control(
    Group_Control_Text_Shadow::get_type(),
    [
        'name' 		=> 'cd_checkout_address_form_label_shadow',
        'selector' 	=> '{{WRAPPER}} .woocommerce-checkout #customer_details .form-row label',
    ]
);

$widget->end_controls_tab();

$widget->start_controls_tab(
    'cd_checkout_address_form_input_tab',
    [
        'label' => esc_html__( 'Input', 'codesigner-pro' ),
    ]
);

$widget->add_control(
    'cd_checkout_address_form_input_color',
    [
        'label'     => esc_html__( 'Color', 'codesigner-pro' ),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce .woocommerce-checkout #customer_details .form-row .input-text' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name' 		=> 'cd_checkout_address_form_input_background',
        'types' 	=> [ 'classic', 'gradient' ],
        'selector' 	=> '{{WRAPPER}} .woocommerce .woocommerce-checkout #customer_details .form-row .input-text',
    ]
);

$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name' 		=> 'cd_checkout_address_form_input_border',
        'selector' 	=> '{{WRAPPER}} .woocommerce .woocommerce-checkout #customer_details .form-row .input-text',
    ]
);

$widget->end_controls_tab();

$widget->end_controls_tabs();

$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_order_section_style',
    [
        'label'      => __( 'Order Section', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'default',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_order_section_heading_color',
    [
        'label' 	=> esc_html__( 'Heading Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce .woocommerce-checkout #order_review_heading' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_order_section_background_color',
    [
        'label' 	=> esc_html__( 'Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce .woocommerce-checkout #order_review_heading' => 'background: {{VALUE}} !important',
            '{{WRAPPER}} .woocommerce .woocommerce-checkout .woocommerce-checkout-review-order' => 'background: {{VALUE}} !important',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_order_section_border_color',
    [
        'label' 	=> esc_html__( 'Border Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce .woocommerce-checkout #order_review_heading' => 'border-color: {{VALUE}} !important',
            '{{WRAPPER}} .woocommerce .woocommerce-checkout .woocommerce-checkout-review-order' => 'border-color: {{VALUE}} !important',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_order_section_border_radius',
    [
        'label' 		=> esc_html__( 'Border-radius', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .woocommerce .woocommerce-checkout #order_review_heading' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} 0 0;',
            '{{WRAPPER}} .woocommerce .woocommerce-checkout .woocommerce-checkout-review-order' => 'border-radius: 0 0 {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_order_details_style',
    [
        'label'      => __( 'Order Details Table', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'default',
        ],
    ]
);

$widget->start_controls_tabs(
    'cd_checkout_order_details_style_tabs'
);

$widget->start_controls_tab(
    'cd_checkout_order_details_heading',
    [
        'label' 	=> esc_html__( 'Table Heading', 'codesigner-pro' ),
    ]
);

$widget->add_control(
    'cd_checkout_order_details_heading_color',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce .woocommerce-checkout .woocommerce-checkout-review-order .woocommerce-checkout-review-order-table thead th' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_order_details_heading_background_color',
    [
        'label' 	=> esc_html__( 'Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce .woocommerce-checkout .woocommerce-checkout-review-order .woocommerce-checkout-review-order-table thead th' => 'background: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_order_details_heading_padding',
    [
        'label' 		=> esc_html__( 'Padding', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .woocommerce .woocommerce-checkout .woocommerce-checkout-review-order .woocommerce-checkout-review-order-table thead th' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->end_controls_tab();

$widget->start_controls_tab(
    'cd_checkout_order_details_body',
    [
        'label' 	=> esc_html__( 'Table Body', 'codesigner-pro' ),
    ]
);

$widget->add_control(
    'cd_checkout_order_details_body_color',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce .woocommerce-checkout .woocommerce-checkout-review-order .woocommerce-checkout-review-order-table tbody td' => 'color: {{VALUE}}',
            '{{WRAPPER}} .woocommerce .woocommerce-checkout .woocommerce-checkout-review-order .woocommerce-checkout-review-order-table tfoot th' => 'color: {{VALUE}}',
            '{{WRAPPER}} .woocommerce .woocommerce-checkout .woocommerce-checkout-review-order .woocommerce-checkout-review-order-table tfoot td' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_order_details_body_background_color',
    [
        'label' 	=> esc_html__( 'Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce .woocommerce-checkout .woocommerce-checkout-review-order .woocommerce-checkout-review-order-table tbody td' => 'background: {{VALUE}}',
            '{{WRAPPER}} .woocommerce .woocommerce-checkout .woocommerce-checkout-review-order .woocommerce-checkout-review-order-table tfoot th' => 'background: {{VALUE}}',
            '{{WRAPPER}} .woocommerce .woocommerce-checkout .woocommerce-checkout-review-order .woocommerce-checkout-review-order-table tfoot td' => 'background: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_order_details_body_padding',
    [
        'label' 		=> esc_html__( 'Padding', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .woocommerce .woocommerce-checkout .woocommerce-checkout-review-order .woocommerce-checkout-review-order-table tbody td' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} .woocommerce .woocommerce-checkout .woocommerce-checkout-review-order .woocommerce-checkout-review-order-table tfoot th' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            '{{WRAPPER}} .woocommerce .woocommerce-checkout .woocommerce-checkout-review-order .woocommerce-checkout-review-order-table tfoot td' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->end_controls_tab();

$widget->end_controls_tabs();

$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_payment_section_style',
    [
        'label'      => __( 'Payment Section', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'default',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_payment_name_color',
    [
        'label' 	=> esc_html__( 'Payment Name Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce .woocommerce-checkout .wc_payment_method' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_payment_desc_color',
    [
        'label' 	=> esc_html__( 'Payment Description Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce .woocommerce-checkout .wc_payment_method .payment_box p' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_payment_privacy_color',
    [
        'label' 	=> esc_html__( 'Privacy Policy Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce .woocommerce-checkout .woocommerce-privacy-policy-text p' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->end_controls_section();

$widget->start_controls_section(
    'cd_checkout_order_button_style',
    [
        'label'      => __( 'Order Button', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_checkout_template' => 'default',
        ],
    ]
);

$widget->add_control(
    'cd_checkout_order_button_color',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .woocommerce .woocommerce-checkout .woocommerce-checkout-payment .form-row .button' => 'color: {{VALUE}}',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name' 		=> 'cd_checkout_order_button_background',
        'types' 	=> [ 'classic', 'gradient' ],
        'selector' 	=> '{{WRAPPER}} .woocommerce .woocommerce-checkout .woocommerce-checkout-payment .form-row .button',
    ]
);

$widget->add_group_control(
    Group_Control_Border::get_type(),
    [
        'name' 		=> 'cd_checkout_order_button_border',
        'selector' 	=> '{{WRAPPER}} .woocommerce .woocommerce-checkout .woocommerce-checkout-payment .form-row .button',
    ]
);

$widget->add_control(
    'cd_checkout_order_button_border_radius',
    [
        'label' 		=> esc_html__( 'Border Radius', 'codesigner-pro' ),
        'type' 			=> Controls_Manager::DIMENSIONS,
        'size_units' 	=> [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors' 	=> [
            '{{WRAPPER}} .woocommerce .woocommerce-checkout .woocommerce-checkout-payment .form-row .button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$widget->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' 		=> 'cd_checkout_order_button_box_shadow',
        'selector' 	=> '{{WRAPPER}} .woocommerce .woocommerce-checkout .woocommerce-checkout-payment .form-row .button',
    ]
);

$widget->end_controls_section();
